CREATE OR REPLACE FUNCTION UpdateColumn()
RETURNS VOID AS
$BODY$
BEGIN
    -- Verifica se as colunas existem na tabela
    IF (EXISTS (SELECT 1 FROM information_schema.columns     
                WHERE LOWER(table_name) = 'rc_resp_tec' 
                      AND LOWER(column_name) = 'cnpj_resptec')
        AND EXISTS (SELECT 1 FROM information_schema.columns     
                WHERE LOWER(table_name) = 'rc_resp_tec' 
                      AND LOWER(column_name) = 'email_resptec')
        AND EXISTS (SELECT 1 FROM information_schema.columns     
                WHERE LOWER(table_name) = 'rc_resp_tec' 
                      AND LOWER(column_name) = 'fone_resptec')
        AND EXISTS (SELECT 1 FROM information_schema.columns     
                WHERE LOWER(table_name) = 'rc_resp_tec' 
                      AND LOWER(column_name) = 'contato_resptec'))
    THEN
        -- Verifica se existe pelo menos um registro na tabela
        IF EXISTS (SELECT 1 FROM RC_RESP_TEC LIMIT 1)
        THEN
            -- Atualiza os valores
            UPDATE RC_RESP_TEC
            SET CNPJ_RESPTEC = '54517628000198',
                EMAIL_RESPTEC = 'DEPTO.HOMOLOGACAO@LINX.COM.BR',
                FONE_RESPTEC = '51992801474',
                CONTATO_RESPTEC = 'RODRIGO KREISS';
        ELSE
            -- Insere os valores caso a tabela esteja vazia
            INSERT INTO RC_RESP_TEC (CD_EMP, CNPJ_RESPTEC, EMAIL_RESPTEC, FONE_RESPTEC, CONTATO_RESPTEC)
            VALUES (1, '54517628000198', 'DEPTO.HOMOLOGACAO@LINX.COM.BR', '51992801474', 'RODRIGO KREISS');
        END IF;
                         
        RAISE NOTICE 'Update realizado com sucesso na rc_resp_tec';

    END IF;
END;
$BODY$
LANGUAGE plpgsql VOLATILE
COST 100;

-- Executa a função
SELECT UpdateColumn();

-- Remove a função se necessário
DROP FUNCTION UpdateColumn();
